//  Created by Allen Ingling on Fri Jun 18 2004.
//  Copyright (c) 2004 New York University. All rights reserved.

#import "PrecisionTime.h"

double GetPrecisionTimeSinceStartupInSecsAsDouble(void)
{
	double				timeDouble, timeDoubleSecs;
	AbsoluteTime		timeAbsTime;
	Nanoseconds			timeNanoseconds;
	UInt64				timeUInt64;

	//Get the time in an AbsolulteTime structure which expresses time as a ratio.
	timeAbsTime=UpTime();
	//Convert the AbsoluteTime structure to nanoseconds stored in an UnsignedWide.
	//UnsignedWide is an opaque type.  Depending on the compiler it is 
	//implemented either as structure holding holding 32-bit high and low parts
	//or as a native long long.  
	timeNanoseconds=AbsoluteToNanoseconds(timeAbsTime);
	//convert the opaque unsigned wide type into a UInt64.  Variant  forms 
	//of the  UnsignedWide type is  why we need to use the UnsignedWideToUInt64() 
	//macro instead of a cast.  If GCC then UnsignedWideToUInt64 is a type recast. 
	timeUInt64=UnsignedWideToUInt64(timeNanoseconds);
	//cast nanoseconds in unsigned wide type to a double
	timeDouble=(double)timeUInt64;
	//divide down to seconds 
	timeDoubleSecs= timeDouble / 1000000000;  

	return(timeDoubleSecs);
}


